7262 Introduction                                       The 7262 plug-in front panel controls allow     changing the timebase, the trigger conditions,    the signal amplifiers, and the display of a       summary of control settings on the mainframe      display.  Whenever a plug-in control is           changed, the plug-in's vertical and timebase      settings are briefly displayed on the screen.     The display indicates the settings to be used     for the next acquisition.  The labels             displayed next to the `MTRACE 1`N through         `MTRACE 8`N keys indicate the name or label of    the displayed trace and the acquisition           parameters used when the waveform was acquired    and are updated with every waveform               acquisition.                                        Note that changes to the control settings       will not be reflected in the displayed            waveform until the 7262 has acquired new data,    since changing the plug-in acquisition            settings has no effect on previously acquired     waveforms.  Therefore, the settings indicated     when controls are changed may differ from         those displayed next to the trace keys when       the 7200A is in the Single or Sequence Trigger    Mode and has finished acquiring data.         Display of Acquisition Parameters                       There are several displays which provide        parameter acquisition information.            Plug-in Status                                          The Plug-in Status screen displays all 7262     control settings.  The acquisition parameters     which do not have a dedicated control on the      front panel are changed from within this          screen.  Pressing the `MDISPLAY`N key or          pressing the `MMODIFY`N key (on the mainframe)    and the the `MDISPLAY`N key  brings up the        Plug-in Status screen.                              The acquisition parameters which do not have    a dedicated control on the front panel can be     changed from within this menu.  To select the     parameter to change, rotate the `MModify          Field`N soft knob until the box moves to the      item to be changed.  To change the item's         value, rotate the `MModify Value`N soft knob      until your choice appears within the box.  The    list of choices are shown in the lower right      corner of the menu, with the current choice in    the center of the list of options.                  The screen is divided into three main           sections:  Trigger Controls, Timebase             Controls, and Vertical Controls.              Vertical Status Screen                                  The Vertical Status screen contains a sub-      set of the control settings shown in the          Plug-in Status display so that the waveforms      can be viewed while the acquisition controls      are being changed.  The Vertical Status screen    appears when you press the `MMODIFY`N key and     then press any key or rotate any knob in the      vertical section on the plug-in's front panel     or when selected from inside the Trigger or       Timebase status screens.                      Trigger Status Screen                                   The Trigger Status screen contains a sub-set    of the control settings shown in the Plug-in      Status display so that the waveforms can be       viewed while the acquisition controls are         being changed.  The Trigger Status screen         appears when you press the `MMODIFY`N key and     then press any key or rotate any knob in the      trigger section on the plug-in's front panel      or when selected from inside the Timebase or      Vertical status screens.                      Timebase Status Screen                                  The Timebase Status screen contains a sub-      set of the control settings shown in the          Plug-in Status display so that the waveforms      can be viewed while the acquisition controls      are being changed.  The Timebase Status screen    appears when you press the `MMODIFY`N key and     then press any key or rotate any knob in the      timebase section on the plug-in's front panel     or when selected from inside the Vertical or      Trigger status screens.                       Plug-in Controls                                        The following sections will describe all the    controls available to the user.               Vertical Controls                                       The Vertical controls adjust signal             amplification for each plug-in channel.  These    adjustments are made either with dedicated        front panel controls or from within the Plug-     in or Timebase Status screens.                      The `MCH1`N or `MCH2`N keys select which        channel the Vertical controls will modify. For    example, when CH1 is pressed, adjusting a         Vertical control will affect CH1 signal input.    CH2 settings remain unchanged.  The channel       LED next to the key is lit to indicate the        selected channel.                                   The `MSelect Channel`N menu field is located    in the Plug-in and Vertical status screens and    is used to select either channel or all           channels. Selecting "all channels" sets all       the vertical control settings for every           channel of the plug-in to be the same as those    of the last channel selected.  Both the CH1       and CH2 led's will be lit and modifiying any      vertical controls will affect CH1 and CH2's       signal input.                                       The `MV/DIV`N (Volts/Division) knob selects     the vertical sensitivity factor in multiples      of 1, 2, and 5. Ranges 200mV, 100mV, and 50mV     all provide the same amount of vertical           resolution.  Ranges 20mV, 10mV and 5mV provide    the next greater degree of vertical               resolution. When having trouble triggering on     signals in the upper range, switch to the         lower range.                                        `MProbe Attenuation`N indicates the probe       attenuation factor included in the vertical       sensitivity indicators. The probe attenuation     can be selected in the Plug-in Status screen      or the Vertical Status screen.  The choices       are x1, x2, x5, x10, x20, x50 and x100.         Total V/Div                                           Total V/Div indicates the current setting of    the front panel Vertical Gain control.          Input Connectors                                      SMA type connectors are used for both CH 1      and CH 2 signal inputs, and the external          trigger connector marked EXT TRIG.  The           maximum permissible input voltage is  2 V.         The `MOFFSET`N knob adjusts the voltage         offset used to position the signal within the     amplifier's input range.  The maximum offset      is  800 mV on the upper voltage gain             settings (50mV to 200mV) and  160 mV on          the lower voltage gain settings (5mV to 20mV).    It is manually adjustable (or programmable) in    0.02 division increments. A pair of upward- or    downward-pointing arrows (  or  ) on            the grid's upper or lower edge indicate when      the trace has been positioned outside of the      grid.                                               The `MZero Offset`N key toggles between zero    offset and the currently selected offset          value.  An LED next to the key lights "ZERO"      to indicate zero offset.                            The `MAverage`N key allows the user to turn     on plug-in averaging. The type of averaging       performed by the plugin is a weighted             continuous average similar to the AVGC            computation function. The `MAverage Weight`N      is selected in the Vertical Status screen. The    weight selections are 2,4,8,16,32 and 64.         Selecting a larger weight will average the        waveform more but will take longer for the        first complete record to be acquired.  When       plugin averaging is turned on, all computation    functions in the mainframe will operate on the    averaged data.                                      The `MPulse`N field in the Vertical Status      screen turns the TDR pulse on or off for a        particular channel. Turn the pulse on to drive    a 0.5 volt square wave out the SMA connector      for channel 1 and/or channel 2. This pulse is     offset by -0.2 V.  The frequency of this pulse    is selected with the `MPulse Period`N field in    the Vertical Status screen.  The range of         frequencies is 5 MHz (0.2sec) to 1 Hz (1         sec).                                         Timebase Controls                                       Timebase controls allow the user to select      the horizontal parameters used to acquire         data.  These parameters are Timebase and Max      Memory.                                             The `MTIMEBASE`N knob is used to select the     amount of time each horizontal division           represents.  The Timebase setting and Max         Memory determine the sampling frequency and       the number of sample points displayed per         division. The detented knob selects the           Timebase in a 1-2-5 sequence from 20 ps/DIV to    200 msec/DIV.  The number of Point/div and the    Time/point is dispalyed in the Plug-in status     or Timebase Status screens.                         `MRandom Interleaved Sampling (RIS)`N is        automatically turned on at time per division      settings of 10 sec or less at which time         the ON led on the 7262 front panel is lit.        For the 7262, the RIS acquisition consists of     many single-shot acquisitions at 40 MS/s that     are interleaved together to produce a final       record that has a much greater effective          sampling rate. At a time per division of 10       sec, the interleave factor is 5:1                resulting in an effective sampling rate of 200    MS/s.  At a time per division of 20nsec and       less, the interleave factor is 2500:1             resulting in an efective sampling rate of 100     GS/s.  Because the triggers are randomly          associated with the sampling process              (uncorrelatd with the sampling clock), the        word random is used in Random Interleaved         Sampling.  This method requires a repetitive      signal source, a stable trigger and a rep-rate    not correlated with the 40MS/s sample clock.        It is interesting to note that considerably     more randomly correlated triggers are required    to fully populate a complete record.  Based on    statistical arguments, the nominal factor is      about 8 to 10 times the interleave factor         (ie., 21,000 sweeps to populate a RIS record      interleaved at 2500).                               `MNumber of Acquisition Channels`N is a         field in the Plug-in and Timebase Status          screens that selects the number of channels       acquiring data.  Selection of 2 channels will     acquire data on all channels with a maximum of    20,000 samples per channel.  Reducing the         number of channels acquiring data speeds the      acquisition and processing of the data.           Channel 2 can be used as a trigger source even    if data is not acquired on it.                      The `MMax Memory`N field appears in the         Plug-in and Timebase Status screens and allows    the user to specify the maximum number of         points to represent each waveform.  Together      with the timebase setting it determines the       the record length and the time per point.  The    choices are 500, 1K, 2K, 5K, ..., 20K points.     Acquire 500 samples to achieve maximum            waveform throughput. Obtaining 20,000 points,     provides a greater window of the signal,          requiring more time to process the additional     points.                                         Points/div                                            Indicates the number of samples in each         division of the display grid, provided the        waveform is not decimated or expanded.          Time/point                                            Indicates the sample rate or the time           between digitized sample points for the           corresponding timebase setting.               Trigger Controls                                        The 7262 offers two independent triggering      methods: Standard and Smart Trigger.  Standard    trigger provides basic trigger functions which    can be controlled from the front panel.  Smart    Trigger adds additional qualifications to the     trigger source(s). The Smart Trigger key on       the plug-in front panel toggles between           selecting either method.  The LED indicates       when Smart Trigger is selected.  Smart Trigger    options can be adjusted either with dedicated     front panel controls or from within the Plug-     in or Trigger Status screens.                       The pair of `MSOURCE`N keys enable trigger      source selection as follows:                      CH 1    Selects Channel 1 as the trigger                  source, i.e., the signal connected to             the Channel 1 SMA input connector.        CH 2    Selects Channel 2 as the trigger                  source, i.e., the signal connected to             the Channel 2 SMA input connector.        Pulse   Selects the internal pulse generator              as the trigger source. This provides a            stable display when the internal pulse            is turned on for a channel.               Ext     With the Trigger source set to EXT, a             signal applied to the SMA connector               labeled "EXT TRIG" is used to trigger             the scope within a range of  800 mV.       When EXT is selected as the trigger source,     a signal applied to the SMA connector labelled    EXT TRIG can be used to trigger the scope when    the signal is between  800 mV.                     The `MCOUPLING`N keys select the type of        signal coupling at the input of each trigger      circuit.  Note that the trigger coupling can      be adjusted independently for each trigger        source.  Therefore, a change of the trigger       source may also result in a change of the         trigger coupling LEDs since the coupling          associated with the newly selected source is      remembered. When the trigger source is PULSE,     only DC trigger coupling can be selected.         Select `MDC`N to trigger on low frequency         signals below 1 GHz.  Select `MHF SYNC`N to       trigger on high frequency signals above 1 GHz.    When HF Sync is ON, the trigger source has its    frequency rate divided by 4.  This allows         stable triggering for sources up to 4 GHz.        When HF Sync is ON, the trigger slope is          always positive regardless of what was            previously selected.  HF Sync can not be used     with Smart Trigger.                                 The `MRelative Delay`N field in the Trigger     Status Screen delays one channel relative to      the other.  It is applied to the acquired data    and does not affect when the data is actually     sampled. Because of this, it is forced to 0       when Smart Trigger is turned on to avoid          confusion. It is used to calibrate out cable      length differences when it is desired to have     Channel 1 and Channel 2 precisely aligned with    each other. Relative delay is adjustable from     -10 nsec to +10 nsec.                               The `MDelay in`N field is used to select the    function of the delay knob.  The choices are      TIME and PERCENT.  When delay is set as a         function of TIME, the delay knob adjusts the      amount of time the signal is recorded             before(pre_trigger) or after(post trigger) the    trigger occurs.  When delay unit is set to        PERCENT, the trigger delay can be positioned      any where on the screen and will remain           constant as the time per division is changed.       The `MDELAY`N knob is used to select the        Trigger Delay.  `MDELAY`N adjusts the amount      of signal recorded before(pre-trigger) or         after(post-trigger) the trigger occurs.  The      pre-trigger amount depends on the Timebase and    memory size.  The delay can be adjusted in        time or as a percentage of the screen.  The       arrow under the grid indicates the trigger        point of the displayed trace.  Trigger delay      is locked to other plug-ins when the timebase     controls are locked.                                The `MZero Delay`N key toggles between the      selected delay setting and a trigger delay of     0.0 sec or 50 %, which would put the trigger      at the center of the grid. An LED next to the     key lights "ZERO" to indicate zero trigger        delay. Trigger delay is locked to other plug-     ins when the timebase controls are locked.          The `MLEVEL`N knob adjusts the voltage level    at which trigger will occur.  When the trigger    level is increased, the trigger circuit will      respond at a higher voltage level. If vertical    sensitivity is adjusted such that the             previously selected trigger level exceeds the     sensitivity range, then the trigger level is      automatically reduced to fit the new range.       The range of trigger levels is as follows:        Trigger Source  Trigger Range                     CH 1 or 2        800 mV at VDIV >= 50mV/div                       160 mV at VDIV <= 20mV/div      PULSE           none (zero-crossing is used)      EXT              800 mV                            The `MZero Level`N key toggles between the      selected trigger level and a trigger level of     0.0 Volts. An LED next to the key lights          "ZERO" to indicate zero trigger level.              The `MSLOPE`N key selects the signal edge       used to activate the trigger circuit.  The        slope of the trigger can be adjusted for each     individual trigger source and is indicated by     LEDs above the `MSLOPE`N key.                     POS        Triggers on a positive-going edge.     NEG        Triggers on a negative-going edge.       A READY LED on each plug-in indicates that      the trigger circuit has been armed and the        plug-in is currently acquiring input signals.     The TRIG'D LED is lit whenever the time base      is stopped (normally after a valid trigger).        The `MSmart Trigger`N key toggles between       selecting the Standard Trigger and the Smart      Trigger.  Smart Trigger is setup from within      the Plug-in and Trigger status screens. An LED    next to the key will light "ON" to indicate       Smart Trigger is selected.  Smart Trigger         offers a variety of trigger qualifications        based on the ability of the 7262 to :               - To count a specified number of events(1 to    15,000,000)                                         - To measure time intervals(1 nsec up to 100    sec)                                                - To recognize a pattern input to the           selected trigger sources.  When Smart Trigger     is selected one of five triggering methods can    be selected:                                        `MSingle Source`N - Trigger on the selected     source when the trigger conditions and one of     the following qualifications are met:               - Holdoff for 10 nsec up to 100 sec.              - Holdoff for 1 to 15,000,000 events.             - Interval < 10 nsec up to 100 sec.               - Interval > 10 nsec up to 100 sec.               - Interval between (10 ns - 100 sec)              and (10 ns - 100 sec)                             - Interval outside of (10 ns - 100 sec)           and (10 ns - 100 sec)                             - Pulse < 1 nsec up to 100 sec.                   - Pulse > 1 nsec up to 100 sec.                   - Pulse between (1 ns - 100 sec)                  and (1 ns - 100 sec)                              - Pulse outside of (1 ns - 100 sec)               and (1 ns - 100 sec)                              `MPattern`N                                       - Trigger whenever the selected combination     of signals occurs and one of the following        qualifications are met:                             - Holdoff for 10 nsec up to 100 sec.              - Holdoff for 1 to 15,000,000 events.             - Interval < 10 nsec up to 100 sec.               - Interval > 10 nsec up to 100 sec.               - Interval between (10 ns to 100 sec)             and (10 ns to 100 sec)                            - Interval outside of (10 ns to 100 sec)          and (10 ns to 100 sec)                            - Time between patterns < trigger                 on entering(1 nsec up to 100 sec).                - Time between patterns > trigger on              entering(1 nsec up to 100 sec).                   - Pattern width < trigger on exiting              (1 nsec up to 100 sec).                           - Pattern width > trigger on exiting              (1 nsec up to 100 sec).                           `MState Qualified`N - Trigger whenever the      trigger source meets its trigger condition        during the selected pattern and one of the        following qualifications are met:                   - Wait for 10 nsec up to 100 sec.                 - And Before 10 nsec up to 100 sec.               - Trigger on 1 to 15,000,000 events.              `MTime Qualified`N - Trigger whenever the       trigger source meets its trigger condition        after the selected combination and one of the     following qualifications are met:                   - Wait for 10 nsec up to 100 sec.                 - And Before 10 nsec up to 100 sec.               - Trigger on 1 to 15,000,000 events.        Calibrate                                               The `MCalibrate`N key ensures overall           vertical, timebase, and trigger accuracy by       calibrating the plugin at it's cuurent            setting.  Calibration is also performed when      the 7200A is powered, when Timebase or            Vertical Controls are adjusted, and               periodically thereafter.  There is a calibrate    softkey located in all Status screens.        Battery Low                                             The 7262 plugin contains a battery to           protect the user's signal source.  When           turning off power, a battery in the 7262          prevents the output from shorting to ground.      If this battery is not fully charged, a           monitoring circuit reports the message: INPUT     SHORTED IF POWER OFF-BATTERY LOW. This is to      warn the user to remove any signal source from    Channel 1 or Channel 2 before turning off         power since the 7262 will short any connected     signal source to ground.                      Timebase Phase Locked/Unlocked                          The 7262 plugin contains a PLL to lock on       the input signal and display a stable             waveform. If the hardware should fail, the        error message:  TIMEBASE PHASE UNLOCKED is        displayed. The most probable cause is problems    with the 10MHz reference clock.               